/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class NetworkNodeListener {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        if (e.world.field_72995_K || e.phase != TickEvent.Phase.END) {
            return;
        }
        e.world.field_72984_F.func_76320_a("network node ticking");
        for (INetworkNode node : API.instance().getNetworkNodeManager(e.world).allTickable()) {
            node.updateNetworkNode();
        }
        e.world.field_72984_F.func_76319_b();
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent e) {
        if (e.getWorld().field_72995_K || !(e.getEntity() instanceof EntityPlayer)) {
            return;
        }
        TileEntity placed = e.getWorld().func_175625_s(e.getPos());
        if (placed == null || !placed.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null)) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            INetworkNodeProxy nodeProxy;
            Object node;
            TileEntity side = e.getWorld().func_175625_s(e.getBlockSnapshot().getPos().func_177972_a(facing));
            if (side == null || !side.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing.func_176734_d()) || (node = (nodeProxy = (INetworkNodeProxy)side.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing.func_176734_d())).getNode()).getNetwork() == null || node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, (EntityPlayer)e.getEntity())) continue;
            WorldUtils.sendNoPermissionMessage((EntityPlayer)e.getEntity());
            e.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        INetworkNodeProxy nodeProxy;
        Object node;
        if (e.getWorld().field_72995_K) {
            return;
        }
        TileEntity tile = e.getWorld().func_175625_s(e.getPos());
        if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null) && (node = (nodeProxy = (INetworkNodeProxy)tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null)).getNode()).getNetwork() != null && !node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, e.getPlayer())) {
            WorldUtils.sendNoPermissionMessage(e.getPlayer());
            e.setCanceled(true);
        }
    }
}

